//setenv LD_LIBRARY_PATH /home/jacek/kylix3/bin

//---------------------------------------------------------------------------

#include <clx.h>
#pragma hdrstop

#include "fMainForm.h"
#include "fAbout.h"
#include "fGoTo.h"

#include <StrUtils.hpp> //PosEx
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.xfm"
TForm1 *Form1;

AnsiString appname = "XEdit";
AnsiString notitle = "Untitled";

bool ViewOnly=false;
AnsiString NazwaPliku="";

//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
        : TForm(Owner)
{
for (int i=1; i<=ParamCount(); i++)
        {
        AnsiString tmp_argv=ParamStr(i);
        //ShowMessage(tmp_argv);
        if (tmp_argv=="-view" || tmp_argv=="-v" || tmp_argv=="/view" || tmp_argv=="/v")
                ViewOnly=true;
                else
                NazwaPliku=tmp_argv;
        }


if (ViewOnly)
        {
        Memo1->ReadOnly=true;
        appname="XView";
        menuitemNew->Enabled=false;
        menuitemSave->Enabled=false;
        menuitemSaveAs->Enabled=false;
        menuitemUndo->Enabled=false;
        menuitemRedo->Enabled=false;
        menuitemCut->Enabled=false;
        menuitemPaste->Enabled=false;
        }

if (!NazwaPliku.IsEmpty())
        {
        filename=NazwaPliku;
        if (FileExists(filename))
                {
                Memo1->Lines->LoadFromFile(filename);
                notitle=filename;
                SetCaptionPad(filename);
                modified=false;
                }
                else
                {
                ShowMessage("File "+filename+" doesn't exist.");
                exit(EXIT_FAILURE);
                }
        }

menuitemWrap->Checked=!menuitemWrap->Checked; menuitemWrapClick(this);
menuitemStatusBar->Checked=!menuitemStatusBar->Checked; menuitemStatusBarClick(this);

/*
Memo1->Lines->Add("Nazwa pliku: "+NazwaPliku);
if (ViewOnly)
        Memo1->Lines->Add("Tryb: read only");
        else
        Memo1->Lines->Add("Tryb: edit");

Memo1->Lines->Add("1) Drukowanie");
Memo1->Lines->Add("2) Replace");
*/
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Memo1Change(TObject *Sender)
{
modified=true;
Memo1Click(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Memo1Click(TObject *Sender)
{
StatusBar1->Panels->Items[0]->Text="Line "+IntToStr(Memo1->CaretPos.Line+1)+", column "+IntToStr(Memo1->CaretPos.Col+1);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemNewClick(TObject *Sender)
{
if (modified)
  {
  TMessageButton klawisz=Application->MessageBox("Text has been modified. Do you want save changes?",appname,TMessageButtons() << smbYes << smbNo << smbCancel);
  if (klawisz==smbCancel) return;
  if (klawisz==smbYes) menuitemSaveClick(Sender);
  }

Memo1->Clear();
SetCaptionPad(notitle);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemOpenClick(TObject *Sender)
{
if (OpenDialog1->Execute())
  {
  filename=OpenDialog1->FileName;
  Memo1->Lines->LoadFromFile(filename);
  SetCaptionPad(filename);
  modified=false;
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemSaveClick(TObject *Sender)
{
if (filename.IsEmpty())
        menuitemSaveAsClick(Sender);
        else
        Memo1->Lines->SaveToFile(filename);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemSaveAsClick(TObject *Sender)
{
if (SaveDialog1->Execute())
  {
  filename=SaveDialog1->FileName;
  Memo1->Lines->SaveToFile(filename);
  SetCaptionPad(filename);
  }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemCloseClick(TObject *Sender)
{
Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemUndoClick(TObject *Sender)
{
Memo1->Undo(); //Nie ma w C++ Builder 6
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemRedoClick(TObject *Sender)
{
Memo1->Redo(); //Nie ma w C++ Builder 6
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemCutClick(TObject *Sender)
{
Memo1->CutToClipboard();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemCopyClick(TObject *Sender)
{
Memo1->CopyToClipboard();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemPasteClick(TObject *Sender)
{
Memo1->PasteFromClipboard();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemFindClick(TObject *Sender)
{
FindDialog1->Execute();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Przejddo1Click(TObject *Sender)
{
Form3->ShowModal();

TCaretPos pos;
pos.Line=StrToInt((AnsiString)Form3->Edit1->Text);
Memo1->CaretPos=pos;
Memo1->SetFocus();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Zaznaczwszystko1Click(TObject *Sender)
{
Memo1->SelectAll();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemWrapClick(TObject *Sender)
{
menuitemWrap->Checked=!menuitemWrap->Checked;
Memo1->WordWrap=menuitemWrap->Checked;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemFontClick(TObject *Sender)
{
FontDialog1->Font=Memo1->Font;
if (FontDialog1->Execute()) Memo1->Font=FontDialog1->Font;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemBgClick(TObject *Sender)
{
if (ColorDialog1->Execute()) Memo1->Color=ColorDialog1->Color;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemStatusBarClick(TObject *Sender)
{
menuitemStatusBar->Checked=!menuitemStatusBar->Checked;
StatusBar1->Visible=menuitemStatusBar->Checked;
Memo1Change(Sender);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::menuitemAboutClick(TObject *Sender)
{
Form2->ShowModal();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::SetCaptionPad(AnsiString filename)
{
unsigned int slashpos=LastDelimiter("\\/",filename);
this->Caption=filename.SubString(slashpos+1,filename.Length()-slashpos)+" - "+appname;
Application->Title=this->Caption;
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FindDialog1Find(TObject *Sender)
{
unsigned caretpos=Memo1->SelStart+Memo1->SelLength;
AnsiString findstring=(AnsiString)FindDialog1->FindText;
if (Memo1->Lines->Text.IsEmpty()) return;
int pozycja=PosEx(findstring,Memo1->Lines->Text,caretpos);
if (pozycja==0)
        {
        ShowMessage(findstring+" not found.");
        }
        else
        {
        Memo1->SelStart=pozycja-1;
        Memo1->SelLength=findstring.Length();
        Memo1->SetFocus();
        }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCloseQuery(TObject *Sender, bool &CanClose)
{
if (modified)
  {
  TMessageButton klawisz=Application->MessageBox("Text has been modified. Do you want save changes?",appname,TMessageButtons() << smbYes << smbNo << smbCancel);
  if (klawisz==smbCancel) CanClose=false;
  if (klawisz==smbYes) menuitemSaveClick(Sender);
  };
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
//Zmienne pomocnicze
modified=false;
filename="";

//Memo
//Memo1->Font->Name="Courier";Memo1.Font.Size:=12;}
//Memo1.HideSelection:=true;

//Forma
this->Caption=notitle+" - "+appname;
}
//---------------------------------------------------------------------------
 
